unit CoreClassesUnit;

interface

uses
  System.ComponentModel,
  System.Collections,
  Borland.Eco.Services,
  Borland.Eco.ObjectRepresentation,
  Borland.Eco.ObjectImplementation,
  Borland.Eco.UmlRt,
  Borland.Eco.UmlCodeAttributes;

type
  Person = class;
  [UmlElement('Package', Id='a3e719b9-b665-47af-a6b4-1ec303e1b458')]
  [EcoCodeGenVersion('2.0')]
  [UmlMetaAttribute('ownedElement', TypeOf(Person))]
  CoreClasses = class
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(CoreClasses))]
  [UmlCollection(TypeOf(Person))]
  IPersonList = interface(ICollection)
    {$REGION 'ECO generated code'}
    function get_Item(index: Integer): Person;
    procedure set_Item(index: Integer; Value: Person);
    property Item[index: Integer]: Person read get_Item write set_Item; default;
    function Add(value: Person): Integer;
    function Contains(value: Person): Boolean;
    function IndexOf(value: Person): Integer;
    procedure Insert(index: Integer; value: Person);
    procedure Remove(value: Person);
    procedure Clear;
    procedure RemoveAt(index: Integer);
    {$ENDREGION 'ECO generated code'}
  end;

  [UmlElement(Id='b6d66d41-5f82-43b6-91c8-d55574fbd50d')]
  Person = class(System.Object, ILoopBack)
  public
  type
    Eco_LoopbackIndices = class
    public
    const
      Eco_FirstMember = 0;
    const
      Eco_MemberCount = (Eco_FirstMember + 1);
    const
      name = Eco_FirstMember;
    end;

    PersonListAdapter = class(ObjectListAdapter, IPersonList)
    public
      constructor Create(source: IList);
      function get_Item(index: Integer): Person;
      procedure set_Item(index: Integer; Value: Person);
      property Item[index: Integer]: Person read get_Item write set_Item; default;
      function Add(value: Person): Integer;
      function Contains(value: Person): Boolean;
      function IndexOf(value: Person): Integer;
      procedure Insert(index: Integer; value: Person);
      procedure Remove(value: Person);
    end;
  protected
  public


    function get_name: string;
    procedure set_name(Value: string);
    [UmlElement(Id='030a9a77-2fa2-48e4-be2e-c4d761682b25', Index=Eco_LoopbackIndices.name)]
    [UmlMetaAttribute('initialValue', '<default>')]
    property name: string read get_name write set_name;
    constructor Create(content: IContent); overload;
    function get_MemberByIndex(index: Integer): System.Object; virtual;
    procedure set_MemberByIndex(index: Integer; value: System.Object); virtual;
    function AsIObject: IObjectInstance;
  strict private
    function IObjectProvider.AsIObject = IObjectProvider_AsIObject;
    function IObjectProvider_AsIObject: IObject;
  strict protected
    eco_Content: IContent;
    procedure Initialize(serviceProvider: IEcoServiceProvider);
    procedure Deinitialize(serviceProvider: IEcoServiceProvider);
  strict private
    {$ENDREGION}
  public
    constructor Create(serviceProvider: IEcoServiceProvider); overload;
  end;

implementation

procedure Person.Initialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content = nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    Self.eco_Content := factory.CreateContent(Self);
    Self.eco_Content.LoopbackValid;
  end;
end;

procedure Person.Deinitialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content <> nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    factory.CreateContentFailed(Self.eco_Content, Self);
    Self.eco_Content := nil;
  end;
end;
{$ENDREGION}

constructor Person.Create(serviceProvider: IEcoServiceProvider);
begin
  inherited Create;
  Self.Initialize(serviceProvider);
  try
    // User code here
  except
    on System.Exception do
    begin
      Self.Deinitialize(serviceProvider);
      raise;
    end;
  end;
end;

function Person.IObjectProvider_AsIObject: IObject;
begin
  Result := Self.eco_Content.AsIObject;
end;

constructor Person.PersonListAdapter.Create(source: IList);
begin
  inherited Create(source);
end;

function Person.PersonListAdapter.get_Item(index: Integer): Person;
begin
  Result := (Person(inherited Adaptee[index]));
end;

procedure Person.PersonListAdapter.set_Item(index: Integer; Value: Person);
begin
  inherited Adaptee[index] := value;
end;

function Person.PersonListAdapter.Add(value: Person): Integer;
begin
  Result := Self.Adaptee.Add(value);
end;

function Person.PersonListAdapter.Contains(value: Person): Boolean;
begin
  Result := Self.Adaptee.Contains(value);
end;

function Person.PersonListAdapter.IndexOf(value: Person): Integer;
begin
  Result := Self.Adaptee.IndexOf(value);
end;

procedure Person.PersonListAdapter.Insert(index: Integer; value: Person);
begin
  Self.Adaptee.Insert(index, value);
end;

procedure Person.PersonListAdapter.Remove(value: Person);
begin
  Self.Adaptee.Remove(value);
end;

function Person.AsIObject: IObjectInstance;
begin
  Result := Self.eco_Content.AsIObject;
end;

constructor Person.Create(content: IContent);
begin
  inherited Create;
  Self.eco_Content := content;
  content.AssertLoopbackUnassigned;
end;

function Person.get_MemberByIndex(index: Integer): System.Object;
begin
  raise System.IndexOutOfRangeException.Create;
end;

procedure Person.set_MemberByIndex(index: Integer; value: System.Object);
begin
  raise System.IndexOutOfRangeException.Create;
end;

function Person.get_name: string;
begin
  Result := (string(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.name)));
end;

procedure Person.set_name(Value: string);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.name, (System.Object(Value)));
end;

end.
